#
# Description:	Create book data
# Called by:	armor_statues:load
# Entity @s:	None
#
data merge storage armor_statues:book_data {'components': {'minecraft:custom_model_data': {'strings': ['armor_statues:book']}, 'minecraft:custom_data': {'datapack': 'ArmorStatuesV2'}, 'minecraft:written_book_content': {'title': 'Statues v2.12', 'author': 'Stick God', 'generation': 0, 'pages': [[{'text': '      ', 'color': 'white'}, {'text': 'Statues v2.12', 'color': 'dark_blue'}, {'text': '   ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'This book allows you to apply basic settings to an armor stand. Clicking the coloured links will adjust the closest armor stand within three blocks.', 'color': 'yellow'}]}}, {'text': '\n         ', 'color': 'white'}, {'text': '⤺', 'bold': True, 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1200'}, 'hover_event': {'action': 'show_text', 'value': {'text': 'Undo', 'color': 'yellow'}}}, {'text': '  ', 'color': 'white'}, {'text': '⟲', 'bold': True, 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_repeat set 1'}, 'hover_event': {'action': 'show_text', 'value': {'text': 'Repeat', 'color': 'yellow'}}}, {'text': '  ', 'color': 'white'}, {'text': '⤻', 'bold': True, 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1201'}, 'hover_event': {'action': 'show_text', 'value': {'text': 'Redo', 'color': 'yellow'}}}, {'text': '\n  Table of Contents', 'color': 'black'}, {'text': '\n', 'color': 'white'}, {'text': '\nStyles', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 2}}, {'text': '     ', 'color': 'white'}, {'text': 'Auto Align', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 7}}, {'text': '\nNudge', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 3}}, {'text': '    ..', 'color': 'white'}, {'text': 'Swap Slots', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 7}}, {'text': '\nRotation', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 4}}, {'text': '  .', 'color': 'white'}, {'text': 'Mirror/Flip', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 8}}, {'text': '\nPointing', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 4}}, {'text': '   ', 'color': 'white'}, {'text': 'Utilities', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 8}}, {'text': '\nPresets', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 5}}, {'text': '  .', 'color': 'white'}, {'text': 'Scale', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 9}}, {'text': '\n', 'color': 'white'}, {'text': 'Adjust', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 6}}, {'text': '    ', 'color': 'white'}, {'text': 'Item Frames', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 9}}, {'text': '\n', 'color': 'white'}, {'text': '         ', 'color': 'white'}, {'text': 'Credits', 'color': 'dark_aqua', 'click_event': {'action': 'change_page', 'page': 10}}, {'text': '\n', 'color': 'white'}, {'text': '\n      ', 'color': 'white'}, {'text': 'Check Target', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 999'}}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '   ', 'color': 'white'}, {'text': 'Style Settings', 'color': 'dark_blue'}, {'text': '\n\nShow Base Plate:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 2'}}, {'text': '\nShow Arms:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 3'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 4'}}, {'text': '\nSmall Stand:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 5'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 6'}}, {'text': '\nApply Gravity:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 7'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 8'}}, {'text': '\nStand Visible:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 9'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 10'}}, {'text': '\nHas Visual Fire:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 13'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 14'}}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '   .', 'color': 'white'}, {'text': 'Nudge Position', 'color': 'dark_blue'}, {'text': '  ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': "Turn gravity off before nudging the Y-position.\n\nRelative Aligned nudging moves the armor stand relative to the player's position and aligned to the block grid.  (X=Left/Right, Z=Away/Towards)\n\nRelative Aligned nudging moves the armor stand relative to the player's exact position.  (X=Left/Right, Y=Above/Below, Z=Away/Towards)\n\nNudges are in 16ths of a block to align with the pixels of the block textures.", 'color': 'yellow'}]}}, {'text': '\n\nX:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 40'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 101'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 102'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 113'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 114'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 103'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 104'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 43'}}, {'text': '\nY:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 44'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 105'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 106'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 115'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 116'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 107'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 108'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 47'}}, {'text': '\nZ:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 48'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 109'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 110'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 117'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 118'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 111'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 112'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 51'}}, {'text': '\n\n     Relative Aligned  ', 'color': 'black'}, {'text': '\nX:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1100'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1101'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1102'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1130'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1131'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1103'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1104'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1105'}}, {'text': '\nZ:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1106'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1107'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1108'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1132'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1133'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1109'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1110'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1111'}}, {'text': '\n     ', 'color': 'white'}, {'text': '\n      Relative Exact  ', 'color': 'black'}, {'text': '\nX:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1112'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1113'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1114'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1134'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1135'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1115'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1116'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1117'}}, {'text': '\nY:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1118'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1119'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1120'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1136'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1137'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1121'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1122'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1123'}}, {'text': '\nZ:', 'color': 'black'}, {'text': '.', 'color': 'white'}, {'text': '⁻8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1124'}}, {'text': '.', 'color': 'white'}, {'text': '⁻3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1125'}}, {'text': '.', 'color': 'white'}, {'text': '⁻1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1126'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1138'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1139'}}, {'text': '.', 'color': 'white'}, {'text': '⁺1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1127'}}, {'text': '.', 'color': 'white'}, {'text': '⁺3', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1128'}}, {'text': '.', 'color': 'white'}, {'text': '⁺8', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1129'}}, {'text': ''}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '   ', 'color': 'white'}, {'text': 'Adjust Rotation', 'color': 'dark_blue'}, {'text': ' ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'The angle step (default 15°) is used for both the stand rotation and the pose adjustments.\n\nToward and Away turn the armor stand to face toward or away from you.', 'color': 'yellow'}]}}, {'text': '\n\n  ', 'color': 'white'}, {'text': '<<', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 56'}}, {'text': '  ', 'color': 'white'}, {'text': '45°', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 120'}}, {'text': ' ', 'color': 'black'}, {'text': '15°', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 121'}}, {'text': ' ', 'color': 'black'}, {'text': '5°', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 122'}}, {'text': ' ', 'color': 'black'}, {'text': '1°', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 123'}}, {'text': '  ', 'color': 'white'}, {'text': '>>', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 57'}}, {'text': '\n\n     ', 'color': 'white'}, {'text': 'Toward', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 124'}}, {'text': '   ', 'color': 'white'}, {'text': 'Away', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 125'}}, {'text': '\n\n         ', 'color': 'white'}, {'text': 'Pointing', 'color': 'dark_blue'}, {'text': '       ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Points selected appendage at head or feet.', 'color': 'yellow'}]}}, {'text': '\nGet Pointer Wand', 'click_event': {'action': 'run_command', 'command': '/trigger pointer_wand'}, 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Use an Armor Stand and a Stick in a crafting table to craft a Pointer Wand.', 'color': 'yellow'}]}}, {'text': '\n', 'color': 'white'}, {'text': 'Head:', 'color': 'black'}, {'text': '    .', 'color': 'white'}, {'text': 'Head', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1160'}}, {'text': '   ', 'color': 'white'}, {'text': 'Feet', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1166'}}, {'text': '\n', 'color': 'white'}, {'text': 'Body:', 'color': 'black'}, {'text': '    .', 'color': 'white'}, {'text': 'Head', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1161'}}, {'text': '   ', 'color': 'white'}, {'text': 'Feet', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1167'}}, {'text': '\n', 'color': 'white'}, {'text': 'R.Arm:', 'color': 'black'}, {'text': '    ', 'color': 'white'}, {'text': 'Head', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1162'}}, {'text': '   ', 'color': 'white'}, {'text': 'Feet', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1168'}}, {'text': '\n', 'color': 'white'}, {'text': 'L.Arm:', 'color': 'black'}, {'text': '    ', 'color': 'white'}, {'text': 'Head', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1163'}}, {'text': '   ', 'color': 'white'}, {'text': 'Feet', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1169'}}, {'text': '\n', 'color': 'white'}, {'text': 'R.Leg:', 'color': 'black'}, {'text': '    ', 'color': 'white'}, {'text': 'Head', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1164'}}, {'text': '   ', 'color': 'white'}, {'text': 'Feet', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1170'}}, {'text': '\n', 'color': 'white'}, {'text': 'L.Leg:', 'color': 'black'}, {'text': '    ', 'color': 'white'}, {'text': 'Head', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1165'}}, {'text': '   ', 'color': 'white'}, {'text': 'Feet', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1171'}}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '   ', 'color': 'white'}, {'text': 'Pose Presets', 'color': 'dark_blue'}, {'text': '    ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'The Death pose is for a figure lying down and requires a separate armor stand for the legs.\n\nRandomized creates a completely unique randomized custom pose.\n\nThe Block and Item presets are designed to hold blocks and items in line with the world grid.', 'color': 'yellow'}]}}, {'text': '\n\nAttention', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 20'}}, {'text': '    .', 'color': 'white'}, {'text': 'Confident', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 30'}}, {'text': '\nWalking', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 21'}}, {'text': '      ..', 'color': 'white'}, {'text': 'Salute', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 31'}}, {'text': '\nRunning', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 22'}}, {'text': '     ..', 'color': 'white'}, {'text': 'Death', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 32'}}, {'text': '\nPointing', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 23'}}, {'text': '     ..', 'color': 'white'}, {'text': 'Facepalm', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 33'}}, {'text': '\nBlocking', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 24'}}, {'text': '     .', 'color': 'white'}, {'text': 'Lazing', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 34'}}, {'text': '\nLungeing', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 25'}}, {'text': '    .', 'color': 'white'}, {'text': 'Confused', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 35'}}, {'text': '\nWinning', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 26'}}, {'text': '      ..', 'color': 'white'}, {'text': 'Formal', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 36'}}, {'text': '\nSitting', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 27'}}, {'text': '       ..', 'color': 'white'}, {'text': 'Sad', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 37'}}, {'text': '\nArabesque', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 28'}}, {'text': ' .', 'color': 'white'}, {'text': 'Joyous', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 38'}}, {'text': '\nCupid', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 29'}, 'underlined': True}, {'text': '        ', 'color': 'dark_green', 'underlined': True}, {'text': 'Stargazing', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 39'}, 'underlined': True}, {'text': '\n', 'color': 'white'}, {'text': 'Randomized', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1150'}}, {'text': '\nBlock', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 141'}}, {'text': '        ..', 'color': 'white'}, {'text': 'Item', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 142'}}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': ' .', 'color': 'white'}, {'text': 'Pose Adjustment', 'color': 'dark_blue'}, {'text': ' ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'The angle step set for adjusting the stand rotation is also used for the pose adjustments.', 'color': 'yellow'}]}}, {'text': '\nGet Adjustment Wand', 'click_event': {'action': 'run_command', 'command': '/trigger adjustment_wand'}, 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Use an Armor Stand and a Warped Fungus On a Stick in a crafting table to craft an Adjustment Wand.', 'color': 'yellow'}]}}, {'text': '\n          .', 'color': 'white'}, {'text': 'X', 'color': 'black'}, {'text': '     .', 'color': 'white'}, {'text': 'Y', 'color': 'black'}, {'text': '     .', 'color': 'white'}, {'text': 'Z', 'color': 'black'}, {'text': '\nHead', 'color': 'black'}, {'text': '   ', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 60'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 61'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 62'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 63'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 64'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 65'}}, {'text': '\n\nBody', 'color': 'black'}, {'text': '   ', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 67'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 66'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 68'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 69'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 70'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 71'}}, {'text': '\n\nR.Arm', 'color': 'black'}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 72'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 73'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 74'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 75'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 77'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 76'}}, {'text': '\n\nL.Arm', 'color': 'black'}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 78'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 79'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 81'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 80'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 82'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 83'}}, {'text': '\n\nR.Leg', 'color': 'black'}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 84'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 85'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 87'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 86'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 89'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 88'}}, {'text': '\n\nL.Leg', 'color': 'black'}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 90'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 91'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 92'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 93'}}, {'text': '  .', 'color': 'white'}, {'text': '-', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 94'}}, {'text': ' .', 'color': 'white'}, {'text': '+', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 95'}}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '    ', 'color': 'white'}, {'text': 'Auto Alignment', 'color': 'dark_blue'}, {'text': '  ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Pose and position an armor stand to align a held block or item with an adjacent block.', 'color': 'yellow'}]}}, {'text': '\n\n', 'color': 'white'}, {'text': 'Block on surface', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 151'}, 'hover_event': {'action': 'show_text', 'value': [{'text': 'Align an armor stand placed on a surface so that a block held by it appears on the surface.', 'color': 'yellow'}]}}, {'text': '\n\n', 'color': 'white'}, {'text': 'Item on surface', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 152'}, 'hover_event': {'action': 'show_text', 'value': [{'text': 'Align an armor stand placed on a surface so that an item held by it appears upright on the surface.', 'color': 'yellow'}]}}, {'text': '\n', 'color': 'white'}, {'text': 'Item flat on surface', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 153'}, 'hover_event': {'action': 'show_text', 'value': [{'text': 'Align an armor stand placed on a surface so that a non-tool item held by it appears flat on the surface.', 'color': 'yellow'}]}}, {'text': '\n', 'color': 'white'}, {'text': 'Tool flat on surface', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 154'}, 'hover_event': {'action': 'show_text', 'value': [{'text': 'Align an armor stand placed on a surface so that a tool held by it appears flat on the surface.', 'color': 'yellow'}]}}, {'text': '\n\n', 'color': 'white'}, {'text': 'Tool rack', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 155'}, 'hover_event': {'action': 'show_text', 'value': [{'text': 'Align an armor stand with a tripwire hook on the wall above it so that a tool held by it appears to be hanging up.\n\nAlso locks the armor stand and disables all slots except the mainhand.', 'color': 'yellow'}]}}, {'text': '\n\n       ', 'color': 'white'}, {'text': 'Swap Slots', 'color': 'dark_blue'}, {'text': '     ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Swap items between equipment slots', 'color': 'yellow'}]}}, {'text': '\n\n.', 'color': 'white'}, {'text': 'Mainhand ', 'color': 'black'}, {'text': '<->', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 161'}}, {'text': ' Offhand', 'color': 'black'}, {'text': '\n  ', 'color': 'white'}, {'text': 'Mainhand ', 'color': 'black'}, {'text': '<->', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 162'}}, {'text': ' Head', 'color': 'black'}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '.', 'color': 'white'}, {'text': 'Pose Mirror & Flip', 'color': 'dark_blue'}, {'text': ' ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': "Mirroring copies the arm or leg pose from left to right or vice versa. Flipping reverses the armor stand's pose entirely.", 'color': 'yellow'}]}}, {'text': '\n\n ', 'color': 'white'}, {'text': 'Mirror Arms', 'color': 'black'}, {'text': '  ', 'color': 'white'}, {'text': 'L>R', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 131'}}, {'text': '  ', 'color': 'white'}, {'text': 'R>L', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 132'}}, {'text': '\n          ', 'color': 'white'}, {'text': 'Legs', 'color': 'black'}, {'text': '  ', 'color': 'white'}, {'text': 'L>R', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 133'}}, {'text': '  ', 'color': 'white'}, {'text': 'R>L', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 134'}}, {'text': '\n\n                  .', 'color': 'white'}, {'text': '<-Flip->', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 135'}}, {'text': '\n\n         ', 'color': 'white'}, {'text': 'Utilities', 'color': 'dark_blue'}, {'text': '        ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': "Copying an armor stand stores it's settings and pose in the book and these can then be pasted into another armor stand. The book must be the selected item in your mainhand or offhand for this to work.\n\nLocking an armor stand prevents it from being changed using the book and disables interaction with the equipment slots.\n\nSealing an armor stand, which is only available in creative mode, does the same and in addition makes it invulnerable", 'color': 'yellow'}]}}, {'text': '\n\n     .', 'color': 'white'}, {'text': 'Copy', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1004'}}, {'text': ' / ', 'color': 'black'}, {'text': 'Paste', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1005'}}, {'text': '\n\n     ', 'color': 'white'}, {'text': 'Lock', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1000'}}, {'text': ' / ', 'color': 'black'}, {'text': 'Unlock', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1001'}}, {'text': '\n\n     ', 'color': 'white'}, {'text': 'Seal', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/function armor_statues:sealing/seal'}}, {'text': ' / ', 'color': 'black'}, {'text': 'Unseal', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/function armor_statues:sealing/unseal'}}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '       .', 'color': 'white'}, {'text': 'Scale', 'color': 'dark_blue'}, {'text': '          ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Scale changes the size of the Armor Stand (this is seperate from the Small attribute).', 'color': 'yellow'}]}}, {'text': '\n\n  ', 'color': 'white'}, {'text': '⁻.5', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1300'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1301'}}, {'text': '.', 'color': 'white'}, {'text': '⁻.01', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1302'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.01', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1303'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.1', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1304'}}, {'text': '.', 'color': 'white'}, {'text': '⁺.5', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger as_trigger set 1305'}}, {'text': '\n\n', 'color': 'white'}, {'text': '      ', 'color': 'white'}, {'text': 'Item Frames', 'color': 'dark_blue'}, {'text': '     ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'To make an item frame invisible it must be one block in front of the players eyes and have an item in the frame.\nAlternatively you can also enter:\n/trigger if_invisible\nTo make the item frame visible remove its item.\n\nMust be in creative to make item frame Fixed, or have it enabled from the admin menu.', 'color': 'yellow'}]}}, {'text': '\n\n', 'color': 'white'}, {'text': 'Invisible item frame', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger if_invisible set 1'}}, {'text': '\n\n', 'color': 'white'}, {'text': 'Fixed Item Frame:', 'color': 'black'}, {'text': '\n        ', 'color': 'white'}, {'text': 'Yes', 'color': 'dark_green', 'click_event': {'action': 'run_command', 'command': '/trigger if_invisible set 2'}}, {'text': ' / ', 'color': 'black'}, {'text': 'No', 'color': 'red', 'click_event': {'action': 'run_command', 'command': '/trigger if_invisible set 3'}}, {'text': '\n\n', 'color': 'white'}], [{'text': ''}, {'text': '«', 'color': 'light_purple', 'click_event': {'action': 'change_page', 'page': 1}}, {'text': '        ', 'color': 'white'}, {'text': 'Credits', 'color': 'dark_blue'}, {'text': '      ', 'color': 'white'}, {'text': 'Ⓘ', 'color': 'dark_purple', 'hover_event': {'action': 'show_text', 'value': [{'text': 'Click on names for links.', 'color': 'yellow'}]}}, {'text': '\n\n  Original concept by', 'color': 'black'}, {'text': '\n       ', 'color': 'white'}, {'text': 'Phssthpok', 'color': '#87325d', 'bold': True, 'click_event': {'action': 'open_url', 'url': 'https://twitter.com/MCPhssthpok'}}, {'text': '\n\n        ', 'color': 'white'}, {'text': 'Additional', 'color': 'black'}, {'text': '\n    ', 'color': 'white'}, {'text': 'improvements by', 'color': 'black'}, {'text': '\n       ', 'color': 'white'}, {'text': 'MSpaceDev', 'color': '#e30000', 'bold': True, 'click_event': {'action': 'open_url', 'url': 'https://www.youtube.com/c/MinecraftSpace'}}, {'text': '\n\n    ', 'color': 'white'}, {'text': 'Development and', 'color': 'black'}, {'text': '\n    ', 'color': 'white'}, {'text': 'improvements by', 'color': 'black'}, {'text': '\n       ', 'color': 'white'}, {'text': 'MukiTanuki', 'color': '#0072e5', 'bold': True, 'click_event': {'action': 'open_url', 'url': 'https://twitter.com/MukiTanuki'}}]]}}}